<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Factura extends Model 
{

    protected $table = 'factura';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function orden()
    {
        return $this->belongsTo('App\Models\OrdenCompra');
    }

    public function detalle()
    {
        return $this->hasOne('App\Models\DetalleFactura');
    }

    public function ordenPagoFactura()
    {
        return $this->hasMany('App\Models\OrdenPagoFactura');
    }

}